﻿using System;

namespace Helion
{
    public interface ILinqToTxt
    {
        /// <summary>
        /// Mapuje nazwy własności na nazwy w bazie danych.
        /// </summary>
        /// <param name="nazwaProperties">Nazwa własności klasy.</param>
        /// <returns>Nazwa kolumny w bazie danych.</returns>
        string MapowanieKolumn(string nazwaWlasnosci);

        /// <summary>
        /// Umieszcza dane z konkretnych kolumn w pola klasy.
        /// </summary>
        /// <param name="nazwaKolumny">Nazwa kolumny w bazie danych.</param>
        /// <param name="dane">Dane z bazy danych.</param>
        void UstawWartoscPola(string nazwaKolumny, object dane);

        /// <summary>
        /// Nazwa tabeli w bazie danych
        /// </summary>
        string NazwaTabeli
        {
            get;
        }
    }
}